/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright        2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUActions.cpp
//
//	Description:
//		Utility routines for playing actions and getting information about
//		items in the actions palette.
//
//	Version history:
//		Version 1.0.0	6/29/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#include "PIUActions.h"



//-------------------------------------------------------------------------------
//
// PIUActionsPlayByName
//
// Play an action given the name of the set and the name of the action.
// Returns any errors immediately.
//-------------------------------------------------------------------------------
SPErr PIUActionsPlayByName(char* setName, char* actionName)
{
	SPErr error = kSPNoError;
	PIActionDescriptor result = NULL;
	PIActionDescriptor descriptor = NULL;
	PIActionReference reference = NULL;
	
	error = sPSActionReference->Make(&reference);
	if (error) goto returnError;

	error = sPSActionReference->PutName(reference, 
 	                                    classAction, 
										actionName);
	if (error) goto returnError;

	error = sPSActionReference->PutName(reference, 
										classActionSet, 
										setName);
	if (error) goto returnError;

	error = sPSActionDescriptor->Make(&descriptor);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutReference(descriptor, 
											  keyNull, 
											  reference);
	if (error) goto returnError;

	error = sPSActionControl->Play(&result, 
		                           eventPlay, 
								   descriptor, 
								   plugInDialogSilent);
	if (error) goto returnError;

	error = PIUCheckPlayResult(result);
	if (error) goto returnError;

returnError:
	if (reference != NULL)
		sPSActionReference->Free(reference);
	if (descriptor != NULL)
		sPSActionDescriptor->Free(descriptor);
	if (result != NULL)
		sPSActionDescriptor->Free(result);
	
	return error;
}




//-------------------------------------------------------------------------------
//
// PIUActionsGetName
//
// Get the name and the length of the name given the set and action indexes.
// Returns any errors immediately.
//-------------------------------------------------------------------------------
SPErr PIUActionsGetName(uint32 setIndex, 
					    uint32 actionIndex, 
					    char* actionName, 
					    uint32* actionNameLength)
{
	SPErr error = kSPNoError;
	PIActionDescriptor result = NULL;
	PIActionDescriptor descriptor = NULL;
	PIActionReference reference = NULL;
	Boolean hasKey = false;

	if (!actionName || !actionNameLength)
		error = kSPBadParameterError;
	if (error) goto returnError;

	error = sPSActionReference->Make(&reference);
	if (error) goto returnError;

	error = sPSActionReference->PutIndex(reference, 
		                                 classAction, 
										 actionIndex);
	if (error) goto returnError;

	error = sPSActionReference->PutIndex(reference, 
										 classActionSet, 
										 setIndex);
	if (error) goto returnError;

	error = sPSActionControl->Get(&result, reference);
	if (error) goto returnError;

	error = sPSActionDescriptor->HasKey(result, 
										keyName,
										&hasKey);
	if (error || !hasKey) goto returnError;

	error = sPSActionDescriptor->GetStringLength(result, 
						                         keyName,
												 actionNameLength);
	if (error) goto returnError;

	error = sPSActionDescriptor->GetString(result, 
						                   keyName,
										   actionName,
										   (*actionNameLength)+1);
	if (error) goto returnError;

returnError:
	if (reference != NULL)
		sPSActionReference->Free(reference);
	if (descriptor != NULL)
		sPSActionDescriptor->Free(descriptor);
	if (result != NULL)
		sPSActionDescriptor->Free(result);
	
	return error;
}


//-------------------------------------------------------------------------------
//
// PIUActionsGetName
//
// Get the name and the length of the name given the set name and action index.
// Returns any errors immediately.
//-------------------------------------------------------------------------------
SPErr PIUActionsGetName(char* setName, 
					    uint32 actionIndex, 
					    char* actionName, 
					    uint32* actionNameLength)
{
	SPErr error = kSPNoError;
	PIActionDescriptor result = NULL;
	PIActionDescriptor descriptor = NULL;
	PIActionReference reference = NULL;
	Boolean hasKey = false;

	if (!actionName || !actionNameLength || !setName)
		error = kSPBadParameterError;
	if (error) goto returnError;

	error = sPSActionReference->Make(&reference);
	if (error) goto returnError;

	error = sPSActionReference->PutIndex(reference, 
		                                 classAction, 
										 actionIndex);
	if (error) goto returnError;

	error = sPSActionReference->PutName(reference, 
										classActionSet, 
										setName);
	if (error) goto returnError;

	error = sPSActionControl->Get(&result, reference);
	if (error) goto returnError;

	error = sPSActionDescriptor->HasKey(result, 
										keyName,
										&hasKey);
	if (error || !hasKey) goto returnError;

	error = sPSActionDescriptor->GetStringLength(result, 
						                         keyName,
												 actionNameLength);
	if (error) goto returnError;

	error = sPSActionDescriptor->GetString(result, 
						                   keyName,
										   actionName,
										   (*actionNameLength)+1);
	if (error) goto returnError;

returnError:
	if (reference != NULL)
		sPSActionReference->Free(reference);
	if (descriptor != NULL)
		sPSActionDescriptor->Free(descriptor);
	if (result != NULL)
		sPSActionDescriptor->Free(result);
	
	return error;
}
// end PIUActions.cpp